define([ 'Portal', 'backbone', 'marionette', 'jquery', 'jquerymobile',
    'moment',
    'jquery.formparams',
    'hbs!modules/jqm-rangepicker/rangeMenu' ],
    function (Portal, Backbone, Marionette, $, jqm, moment, formparams, template) {
        "use strict";
        return Backbone.View.extend({
            id: "range-menu",
            attributes: {
                "data-role": "popup",
                "data-overlay-theme": "a",
                "data-dismissable": "false",
                "data-shadow": "true",
                "data-theme": "a",
                "class": "ui-corner-all"
            },
            initialize: function (options) {
                var startDate = moment().subtract('days', 730).format("L"), //2 years ago
                    endDate = moment().format("L"); //today

				this.template = template;
                this.startDate = options.startDate || startDate;
                this.endDate = options.endDate || endDate;
                this.maxSpan = options.maxSpan || 6;
                this.minSpan = options.minSpan || -100;
                this.onApply = options.onApply;
                this.caller = options.caller || null;
            },
            render: function () {
                this.destroy();

                $('body').append(
                    this.$el.append(
                        this.template(this)
                    )
                );

                this.activatePopup();

                return this;
            },
            events: {
                'click #range-apply-btn': 'applyRange',
                'tap [title="Close"]': 'callerFocus',
                'keyup button, input, a': 'checkEsc'
            },
            checkEsc: function (e) {
                //for some reason delay is needed... so have to cache caller
                if (e.which === 27 && this.caller) { var caller = this.caller, delay=setTimeout(function(){caller.focus();},100) }
            },
            callerFocus: function () {
                if (this.caller && this.caller.$el) { this.caller.$el.focus(); }
            },
            activatePopup: function () {
                var view = this,
                    $rangeMenu = view.$el;

                $rangeMenu.popup();
                if($.mobile.activePage){
                    //this if statement avoids problems with unit testing
                    $rangeMenu.trigger('create');
                    $rangeMenu.popup('open');
                }

                $(window).resize();

                view.$from = $('#filter-date-from');
                view.$to = $('#filter-date-to');

                var closeDatePicker = function () {
                    var dateFromValue = view.$from.val(),
                        dateToValue = view.$to.val(),
                        dateTo = new Date(dateToValue),
                        dateFrom = new Date(dateFromValue),
                        maxSpan = view.maxSpan,
                        capDate = new Date(dateFromValue).setFullYear(dateFrom.getFullYear() + maxSpan);

                    view.$el.popup('open');
                    if(dateTo < dateFrom || dateTo > capDate ){
                        view.$to.val('').focus();
                    }

                    view.restrictDate();
                    $('#range-apply-btn').button(view.$to.val().length > 0 ? 'enable' : 'disable');
                };

                $('#filter-date-from, #filter-date-to').mobile508datepicker({
                    onClose: closeDatePicker,
                    "leading-zero": true
                });

                this.$from.focus();

                this.restrictDate();
            },
            restrictDate: function () {
                var fromDate = new Date(this.$from.val()),
                    cloned = new Date(this.$from.val()).setFullYear(fromDate.getFullYear() + this.maxSpan),
                    today = new Date(),
                    upToMaxMore = cloned < today ? cloned : today,
                    fromMin = new Date().setFullYear(today.getFullYear() + this.minSpan);

                this.$from.data().options = {
                    MIN: fromMin,
                    MAX: today
                };
                this.$to.data().options = {
                    MIN: fromDate,
                    MAX: upToMaxMore
                };
            },
            applyRange: function (e) {
                if (this.onApply) {
                    var formParams = $(e.currentTarget).parents('form').formParams();

                    this.onApply(formParams, this.caller);
                }

                this.$el.popup('close');
                this.callerFocus();
            },
            destroy: function () {
				$('#range-menu, #date-picker').remove();
            }
        });
    }
);